﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Runtime.InteropServices;
using System.Windows.Interop;
using System.Windows.Controls.Primitives;

namespace MenuTest
{
	public partial class Window1 : Window
	{
		System.Windows.Threading.DispatcherTimer FTimer;

		public Window1()
		{
			InitializeComponent();
		}

		private void button1_Click(object sender, RoutedEventArgs e)
		{

		}

		private void MenuItem_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("yes");
		}

		private void mnuFileNew_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuFileNew_Click");
		}

		private void mnuEditBold_Checked(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditBold_Checked");
		}

		private void mnuEditBold_Unchecked(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditBold_Unckecked");
		}

		private void mnuEditItalic_Checked(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditItalic_Checked");
		}

		private void mnuEditItalic_Unchecked(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditItalic_Unchecked");
		}

		private void mnuEditIncreaseFont_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditIncreaseFont_Click");
		}

		private void mnuEditDecreaseFont_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditDecreaseFont_Click");
		}

		private void mnuFileExit_Click(object sender, RoutedEventArgs e)
		{
			this.Close();
		}

		private void mnuEditCopy_Click(object sender, RoutedEventArgs e)
		{
			//MessageBox.Show("mnuEditCopy_Click");
		}

		private void mnuEditCut_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditCut_Click");
		}

		private void mnuEditPaste_Click(object sender, RoutedEventArgs e)
		{
			MessageBox.Show("mnuEditPaste_Click");
		}

		private void mnuEditCut_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			MessageBox.Show("mnuEditCut_Executed");
		}

		private void mnuEditCut_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			//MessageBox.Show("mnuEditCut_CanExecute");
		}

		private void mnuEditPaste_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			MessageBox.Show("mnuEditPaste_Executed");
		}

		private void mnuEditPaste_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			if (Clipboard.ContainsText() == true)
			{
				textBox1.Paste();

			}
		}

		private void Application_Startup(object sender, StartupEventArgs e)
		{
			//MessageBox.Show("start");
		}

		private void mnuEditCopy_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			textBox1.Copy();
		}

		private void mnuEditCopy_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			if (textBox1.SelectedText.Length < 1)
				e.CanExecute = false;
			else
				e.CanExecute = true;
		}

		private void mnuFileExit_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			this.Close();
		}

		private void mnuFileNew_Executed(object sender, ExecutedRoutedEventArgs e)
		{
		}

		private void mnuShowProgress_Click(object sender, RoutedEventArgs e)
		{
			progressBar.Maximum = 10;
			progressBar.Minimum = 0;
			progressBar.Value = 0;
			progressBar.Visibility = Visibility.Visible;

			FTimer = new System.Windows.Threading.DispatcherTimer();
			FTimer.Interval = TimeSpan.FromMilliseconds(200);

			FTimer.Tick += new EventHandler(timer_Tick);
			FTimer.Start();
		}

		private void timer_Tick(object sender, EventArgs e)
		{
			if (progressBar.Value > 9)
			{
				FTimer.Stop();
				progressBar.Visibility = Visibility.Hidden;
				FTimer.Tick -= new EventHandler(timer_Tick);
				return;
			}

			progressBar.Value += 1;
		}

		private void mnuShowSize_Click(object sender, RoutedEventArgs e)
		{
			mnuShow50.IsChecked = false;
			mnuShow100.IsChecked = false;
			mnuShow200.IsChecked = false;

			MenuItem item = sender as MenuItem;

			if (item != null)
				item.IsChecked = true;
		}
	} // end of Window1 class

	//******************************************************************************************
	public static class Commands
	{
		public static readonly ICommand CloseCommand;

		static Commands()
		{
			var inputGestures = new InputGestureCollection();
			inputGestures.Add(new KeyGesture(Key.Left, ModifierKeys.Control, "Ctrl+←"));
			CloseCommand = new RoutedUICommand("終了(_X)", "CloseCommand", typeof(Commands), inputGestures);
		}
	} // end of Commands class

} // end of namespace
